CONTAINER XSLABanji

{

	NAME XSLABanji;

	INCLUDE Mpreview;

	INCLUDE Mbase;



	GROUP Obaselist

	{

		BOOL SLA_BANJI_DIFFUSE { PARENTMSG ID_BANJI_DIFFUSE; }

		BOOL SLA_BANJI_SPECULAR1 { PARENTMSG ID_BANJI_SPECULAR1; }

		BOOL SLA_BANJI_SPECULAR2 { PARENTMSG ID_BANJI_SPECULAR2; }

		BOOL SLA_BANJI_SPECULAR3 { PARENTMSG ID_BANJI_SPECULAR3; }

		BOOL SLA_BANJI_TRANSPARENCY { PARENTMSG ID_BANJI_TRANSPARENCY; }

		BOOL SLA_BANJI_REFLECTION { PARENTMSG ID_BANJI_REFLECTION; }

		BOOL SLA_BANJI_ENVIRONMENT { PARENTMSG ID_BANJI_ENVIRONMENT; }

		BOOL SLA_BANJI_AMBIENT { PARENTMSG ID_BANJI_AMBIENT; }

		BOOL SLA_BANJI_ROUGHNESS { PARENTMSG ID_BANJI_ROUGHNESS; }

		BOOL SLA_BANJI_ANISOTROPY { PARENTMSG ID_BANJI_ANISOTROPY; }

		BOOL SLA_BANJI_ESOTERICA { PAGE; HIDDEN; PARENTMSG ID_BANJI_ESOTERICA; }

	}



	GROUP ID_BANJI_DIFFUSE

	{

		COLOR SLA_BANJI_DIFFUSE_SURF_COLOR { }

		LONG SLA_BANJI_DIFFUSE_ALGORITHM

		{

			CYCLE

			{

				SLA_BANJI_DIFFUSE_ALGORITHM_INTERNAL;

				SLA_BANJI_DIFFUSE_ALGORITHM_OREN_NAYAR;

			}

		}

		REAL SLA_BANJI_DIFFUSE_ROUGHNESS { UNIT PERCENT; MIN 0; MAX 200; }

		REAL SLA_BANJI_DIFFUSE_SURF_ILLUMINATION { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_DIFFUSE_CONTRAST { UNIT PERCENT; MIN -1000; MAX 1000; }

		SEPARATOR { LINE; }

		COLOR SLA_BANJI_DIFFUSE_VOL_COLOR { }

		REAL SLA_BANJI_DIFFUSE_VOL_ILLUMINATION { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_DIFFUSE_SHADOW_OPACITY { UNIT PERCENT; MIN 0; MAX 100; }

	}

	GROUP ID_BANJI_SPECULAR1

	{

		COLOR SLA_BANJI_SPEC1_COLOR { };

		REAL SLA_BANJI_SPEC1_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_SPEC1_SIZE { UNIT PERCENT; MIN 0; MAX 200; }

		REAL SLA_BANJI_SPEC1_CONTRAST { UNIT PERCENT; MIN 0; MAX 100; }

		REAL SLA_BANJI_SPEC1_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_SPEC1_FALLOFF { UNIT PERCENT; MIN 0; }

	}

	GROUP ID_BANJI_SPECULAR2

	{

		COLOR SLA_BANJI_SPEC2_COLOR { };

		REAL SLA_BANJI_SPEC2_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_SPEC2_SIZE { UNIT PERCENT; MIN 0; MAX 200; }

		REAL SLA_BANJI_SPEC2_CONTRAST { UNIT PERCENT; MIN 0; MAX 100; }

		REAL SLA_BANJI_SPEC2_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_SPEC2_FALLOFF { UNIT PERCENT; MIN 0; }

	}

	GROUP ID_BANJI_SPECULAR3

	{

		COLOR SLA_BANJI_SPEC3_COLOR { };

		REAL SLA_BANJI_SPEC3_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_SPEC3_SIZE { UNIT PERCENT; MIN 0; MAX 200; }

		REAL SLA_BANJI_SPEC3_CONTRAST { UNIT PERCENT; MIN 0; MAX 100; }

		REAL SLA_BANJI_SPEC3_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_SPEC3_FALLOFF { UNIT PERCENT; MIN 0; }

	}

	GROUP ID_BANJI_TRANSPARENCY

	{

		REAL SLA_BANJI_TRANS_FRONT_OPACITY { UNIT PERCENT; MIN 0; MAX 100; }

		REAL SLA_BANJI_TRANS_BACK_OPACITY { UNIT PERCENT; MIN 0; MAX 100; }

		REAL SLA_BANJI_TRANS_EDGE_OPACITY { UNIT PERCENT; MIN 0; }

		REAL SLA_BANJI_TRANS_REFRACTION_INDEX { STEP .01; MIN 0.25; MAX 4.0; }

		BOOL SLA_BANJI_TRANS_INTERNAL_REFLECTION { }

		BOOL SLA_BANJI_TRANS_SOLID_OBJECT { }

	}



	GROUP ID_BANJI_REFLECTION

	{

		REAL SLA_BANJI_REFLECTION_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_REFLECTION_EDGE_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_REFLECTION_FALLOFF { UNIT PERCENT; MIN 0; }

		REAL SLA_BANJI_REFLECTION_DEPTH_ATTENUATION { UNIT PERCENT; MIN 0; MAX 1000; }

		SEPARATOR { LINE; }

		COLOR SLA_BANJI_REFLECTION_REFLECTION_COLOR { }

		COLOR SLA_BANJI_REFLECTION_EDGE_COLOR { }

	}

	GROUP ID_BANJI_ENVIRONMENT

	{

		SHADERLINK SLA_BANJI_ENVIRONMENT_IMAGE { }

		REAL SLA_BANJI_ENVIRONMENT_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_ENVIRONMENT_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_ENVIRONMENT_FALLOFF { UNIT PERCENT; MIN 0; }

		SEPARATOR { LINE; }

		BOOL SLA_BANJI_ENVIRONMENT_UTILIZE_ANISO_SCRATCHES { }

		REAL SLA_BANJI_ENVIRONMENT_BLUR { UNIT PERCENT; MIN 0; MAX 100; }

		LONG SLA_BANJI_ENVIRONMENT_SAMPLES { MIN 1; }

		REAL SLA_BANJI_ENVIRONMENT_JITTER { UNIT PERCENT; MIN 0; MAX 1000; }

		SEPARATOR { LINE; }

		COLOR SLA_BANJI_ENVIRONMENT_ENVIRONMENT_COLOR { }

		COLOR SLA_BANJI_ENVIRONMENT_EDGE_COLOR { }

	}

	GROUP ID_BANJI_AMBIENT

	{

		COLOR SLA_BANJI_AMBIENT_COLOR { }

		REAL SLA_BANJI_AMBIENT_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_AMBIENT_EDGE_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_AMBIENT_FALLOFF { UNIT PERCENT; MIN 0; }

	}

	GROUP ID_BANJI_ROUGHNESS

	{

		LONG SLA_BANJI_ROUGHNESS_SEED { }

		LONG SLA_BANJI_ROUGHNESS_NOISE

		{

			CYCLE

			{

			}

			CUSTOMGUI NOISE; NOISE_OFFSET 2100;

		}

		REAL SLA_BANJI_ROUGHNESS_AMPLITUDE { UNIT PERCENT; MIN -1000; MAX 1000; }

		REAL SLA_BANJI_ROUGHNESS_OCTAVES { MIN 0; MAX 20; STEP .5; }

		REAL SLA_BANJI_ROUGHNESS_SCALE { UNIT PERCENT; MIN 0; }

		REAL SLA_BANJI_ROUGHNESS_SPEED { UNIT PERCENT; MIN -100; MAX 100; }

		REAL SLA_BANJI_ROUGHNESS_ATTENUATION { UNIT PERCENT; MIN 0; MAX 1000; }

		REAL SLA_BANJI_ROUGHNESS_DELTA { UNIT PERCENT; MIN 0; }

		BOOL SLA_BANJI_ROUGHNESS_HARD_BUMP { }

		BOOL SLA_BANJI_ROUGHNESS_ABSOLUTE { }

		SEPARATOR { LINE; }

		REAL SLA_BANJI_ROUGHNESS_LOW_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }

		REAL SLA_BANJI_ROUGHNESS_HIGH_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }

		COLOR SLA_BANJI_ROUGHNESS_GRIT_COLOR { }

		REAL SLA_BANJI_ROUGHNESS_GRIT_INTENSITY { UNIT PERCENT; MIN -200; MAX 200; MINSLIDER -200; MAXSLIDER 200; CUSTOMGUI REALSLIDER; }

		REAL SLA_BANJI_ROUGHNESS_GRIT_LOW_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }

		REAL SLA_BANJI_ROUGHNESS_GRIT_HIGH_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }

	}

	GROUP ID_BANJI_ANISOTROPY

	{

		LONG SLA_BANJI_ANISOTROPY_PROJECTION

		{

			CYCLE

			{

				SLA_BANJI_ANISOTROPY_PROJECTION_PLANAR;

				SLA_BANJI_ANISOTROPY_PROJECTION_AUTO_PLANAR;

				SLA_BANJI_ANISOTROPY_PROJECTION_SHRINK_WRAP;

				SLA_BANJI_ANISOTROPY_PROJECTION_RADIAL_AUTO_PLANAR;

				SLA_BANJI_ANISOTROPY_PROJECTION_RAD_PATTERN_AUTO_PLANAR;

				SLA_BANJI_ANISOTROPY_PROJECTION_RADIAL_PLANAR;

				SLA_BANJI_ANISOTROPY_PROJECTION_RAD_PATTERN_PLANAR;

			}

		}

		REAL SLA_BANJI_ANISOTROPY_PROJ_SCALE { UNIT PERCENT; MIN 0; MAX 1000; }

		SEPARATOR { LINE; }

		REAL SLA_BANJI_ANISOTROPY_X_ROUGH { UNIT PERCENT; MIN 0; }

		REAL SLA_BANJI_ANISOTROPY_Y_ROUGH { UNIT PERCENT; MIN 0; }

		SEPARATOR { LINE; }

		REAL SLA_BANJI_ANISOTROPY_AMPL { UNIT PERCENT; MIN 0; MAX 100; }

		REAL SLA_BANJI_ANISOTROPY_SCALE { UNIT PERCENT; MIN 0; }

		REAL SLA_BANJI_ANISOTROPY_LENGTH { UNIT PERCENT; MIN 0; }

		REAL SLA_BANJI_ANISOTROPY_ATT { UNIT PERCENT; MIN 0; }

		BOOL SLA_BANJI_ANISOTROPY_CHANNEL1 { }

		BOOL SLA_BANJI_ANISOTROPY_CHANNEL2 { }

		BOOL SLA_BANJI_ANISOTROPY_CHANNEL3 { }

	}

	INCLUDE Millum;

	GROUP ID_BANJI_ESOTERICA

	{

		REAL SLA_BANJI_ESOTERICA_OPACITY { UNIT PERCENT; MIN 0; MAX 100; }

	}

	INCLUDE Massign;

}  

